/*****************************************************************************
*  LPC54xx 2ch Two channel PWM program for LPCXpresso board
*
*  1. Use SCT0_IN1 input from switch(SW1)
*  2. SCT0_OUT5 is linked to P1_2 (Green Led)
*  3. SCT0_OUT4 is linked to P1_1 (blue Led)
*  4. The green Led flashes with short duty cycle while the blue led flashed with
*  	  long duty cycle.
*****************************************************************************/
#include "board.h"

/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/
#define match_green_OFF     (5000000)
#define match_green_ON      (4000000)
#define match_blue_OFF      (9000000)
#define match_blue_ON       (1000000)
#define delay               (10000000)

/*****************************************************************************
 * Private functions
 ****************************************************************************/
void SCT_Init(void);
/*****************************************************************************
 * Public functions
 ****************************************************************************/

void SCT_Init(void)
{

	Chip_SCT_Config(LPC_SCT, SCT_CONFIG_32BIT_COUNTER |
                            SCT_CONFIG_AUTOLIMIT_L );												        // unified timer and auto limit


	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_0, delay);						      				    // match_cycle
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_1, match_green_OFF);			  						// match_green_OFF
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_2, match_green_ON);				  					// match_green_ON
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_3, match_blue_OFF);				  					// match_red_OFF
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_4, match_blue_ON);				    				  // match_red_ON

	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_0, ENABLE_STATE0);					    				// event 0 happens in state 0
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_0 , (CHIP_SCT_EVENTCTRL_T) ( SCT_EVECTRL_MATCH0|		// related to match_cycle
                                                                        SCT_IOSEL_1 		|     // SCT0_IN1 select
                                                                        SCT_IOCOND_LOW	|		  // IN_1 low
                                                                        SCT_COMBMODE_AND  |		// match AND IO condition
                                                                        SCT_STATELD_1	    |		// STATEV is loaded into state
                                                                        SCT_STATEEV_1	    ));	// new state is 1


	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_1, ENABLE_STATE0); 					    				// event 1 happens in state 0
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_1 , (CHIP_SCT_EVENTCTRL_T) ( SCT_EVECTRL_MATCH3 |
                                                                        SCT_IOSEL_1	|             // SCT0_IN1 select
                                                                        SCT_COMBMODE_MATCH ));  	// match_red_OFF only condition


	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_2, ENABLE_STATE0); 					    				// event 2 happens in state 0
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_2,  (CHIP_SCT_EVENTCTRL_T) ( SCT_EVECTRL_MATCH4	|
                                                                        SCT_IOSEL_1	        |   // SCT0_IN1 select
                                                                        SCT_COMBMODE_MATCH	));	// match_red_ON only condition

	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_3, ENABLE_STATE1); 					    				// event 3 happens in state 1
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_3, (CHIP_SCT_EVENTCTRL_T) (  SCT_EVECTRL_MATCH0	|	  // related to match_cycle
                                                                        SCT_IOSEL_1	        |   // SCT0_IN1 select
                                                                        SCT_IOCOND_HIGH	    |	  // IN_1 high
                                                                        SCT_COMBMODE_AND	  |	  // match AND IO condition
                                                                        SCT_STATELD_1		    |	  // STATEV is loaded into state
                                                                        SCT_STATEEV_0		    ));	// new state is 0


	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_4, ENABLE_STATE1); 					    				// event 4 happens in state 1
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_4, (CHIP_SCT_EVENTCTRL_T) (  SCT_EVECTRL_MATCH2	 |
                                                                        SCT_IOSEL_1	|             // SCT0_IN1 select
                                                                        SCT_COMBMODE_MATCH   ));	// match_green_ON only condition

	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_5, ENABLE_STATE1); 					    				// event 5 happens in state 1
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_5, (CHIP_SCT_EVENTCTRL_T) (  SCT_EVECTRL_MATCH1	 |	// match_green_OFF only condition
                                                                        SCT_IOSEL_1	         |  // SCT0_IN1 select
                                                                        SCT_COMBMODE_MATCH	 ));

	Chip_SCT_SetOutput(LPC_SCT, SCT_OUTPUT_5,  (CHIP_SCT_EVENT_T)  (    SCT_EVT_0 |
                                                                      SCT_EVT_3 |
                                                                      SCT_EVT_5 )); 				// event 0, 3 and 5 set OUT5 (green LED)

	Chip_SCT_ClearOutput(LPC_SCT, SCT_OUTPUT_5, SCT_EVT_4);					      					// event 4 clear OUT5 (green LED)

	Chip_SCT_SetOutput(LPC_SCT, SCT_OUTPUT_4, (CHIP_SCT_EVENT_T)  (  SCT_EVT_0 |
                                                                   	 SCT_EVT_1 |
                                                                   	 SCT_EVT_3 ));					// event 0, 1 and 3 set OUT4 (Blue LED)

	Chip_SCT_ClearOutput(LPC_SCT, SCT_OUTPUT_4, SCT_EVT_2);											// event 2 clear OUT4 (red LED)

	Chip_SCT_Output(LPC_SCT, 0x30 );     															// default set OUT5 and OUT4

	Chip_SCT_ClearControl(LPC_SCT,SCT_CTRL_HALT_L);	   												// unhalt it by clearing bit 2 of the CTRL register
}



int main(void)
{
	SystemCoreClockUpdate();
	Board_Init();
  
  LPC_SYSCON->AHBCLKDIV = 8;

	Chip_SCT_Init(LPC_SCT);																		// enable the SCT clock

	Chip_Clock_EnablePeriphClock((CHIP_SYSCON_CLOCK_T) ( 	SYSCON_CLOCK_GPIO0	|    			// enable GPIO port 0 clock
                                                        SYSCON_CLOCK_GPIO1	| 	      // enable GPIO port 1 clock
                                                        SYSCON_CLOCK_IOCON	|         //enable IOCON clock
                                                        SYSCON_CLOCK_INPUTMUX	));			//enable MUX clock




	Chip_GPIO_SetPinDIR(LPC_GPIO, 0, 24, false);



	Chip_IOCON_PinMuxSet(LPC_IOCON, 0, 24, 	IOCON_FUNC0 		  	|
                                          	IOCON_I2C_SLEW		  	|
                                          	IOCON_DIGITAL_EN	  	|
                                          	IOCON_INPFILT_OFF	  	|
                                          	0x0 << 6			    |
                                          	0x0 << 9			    |
                                          	0x1 << 10			    );


	Chip_IOCON_PinMuxSet(LPC_IOCON, 1, 2, IOCON_FUNC3 | IOCON_MODE_INACT | IOCON_DIGITAL_EN | IOCON_INPFILT_OFF);		//SCT0_OUT5 = P1.2  (green   LED)
	Chip_IOCON_PinMuxSet(LPC_IOCON, 1, 1, IOCON_FUNC3 | IOCON_MODE_INACT | IOCON_DIGITAL_EN | IOCON_INPFILT_OFF);		//SCT0_OUT4 = P1.1  (blue   LED)


    SCT_Init();                                          										// Initialize SCT0

    while (1)                                              										// loop forever
    {
    	__WFI();
    }
}
